ORCA/M Asm65816 2.1.0

0001 DBDF              *******************************************************
0002 DBDF              *
0003 DBDF              * Apple IIGS Scheduler
0004 DBDF              *
0005 DBDF              * Copyright (c) 1986-1989, 
0006 DBDF              * Apple Computer, Inc.
0007 DBDF              * All Rights Reserved
0008 DBDF              *
0009 DBDF              * Original Code by 
0010 DBDF              *                   John Worthington 20 May 86
0011 DBDF              *
0012 DBDF              * Convted to ASM816
0013 DBDF              *                   John Worthington 3 Oct 86
0014 DBDF              *
0015 DBDF              * Converted to MAX
0016 DBDF              *                   Steven Glass 10 Jun 88
0017 DBDF              *
0018 DBDF              * Removed Org *-1
0019 DBDF              *                   Steven Glass 7 Oct 88
0020 DBDF              *
0021 DBDF              * 17 Oct 88         Steven Glass
0022 DBDF              *
0023 DBDF              * References to oEndCall0 and oEndCall4 are now JMLs 
0024 DBDF              * since this is orged in bank $FD.
0025 DBDF              *
0026 DBDF              * 10 Nov 88         Dave Good & Konstantin Othmer
0027 DBDF              *
0028 DBDF              * Changed DecBusy to be faster in the common cases.
0029 DBDF              *
0030 DBDF              * 14 Nov 88         Steven Glass
0031 DBDF              *
0032 DBDF              * Switched reference to Offset in decBusyFlg to 
0033 DBDF              * long addressing because it was made before dbr
0034 DBDF              * was set (changed on 10 Nov 88)
0035 DBDF              *
0036 DBDF              * Added line to zero schActive on BootInit and Reset.
0037 DBDF              *
0038 DBDF              *******************************************************
0039 DBDF
0040 DBDF                       include '::sys.equs.asm' 
0041 DBDF
0042 DBDF
0043 DBDF              SchedulerCallTable PROC Export 
0044 DBDF
0045 DBDF                       import oEndCall0 
0046 DBDF                       import oEndCall4 
0047 DBDF
0048 DBDF
0049 DBDF                       LONGA ON
0050 DBDF                       LONGI ON
0051 DBDF
0052 DBDF
0053 DBDF
0054 DBDF 0B 00 00 00  TheStart DC L:(TheEnd-TheStart)/4
0055 DBE3 0A DC FC 00           DC L:SchBootInit-1             ; 1
0056 DBE7 42 DC FC 00           DC L:SchAppInit-1              ; 2
0057 DBEB 42 DC FC 00           DC L:SchApTerm-1               ; 3
0058 DBEF 46 DC FC 00           DC L:Schversion-1              ; 4
0059 DBF3 0D DC FC 00           DC L:SchReset-1                ; 5
0060 DBF7 4B DC FC 00           DC L:SchStatus-1               ; 6
0061 DBFB DE FB FE 00           DC L:oEndCall0-1               ; 7   reserved
0062 DBFF DE FB FE 00           DC L:oEndCall0-1               ; 8   reserved
0063 DC03 5F DC FC 00           DC L:schaddtask-1              ; 9
0064 DC07 54 DC FC 00           DC L:schflush-1                ; 10
0065 DC0B              TheEnd    
0066 DC0B
0067 DC0B
0068 DC0B
0069 DC0B
0070 DC0B 18           SchBootInit clc                         ;Indicate from here
0071 DC0C 90 01                 bcc   Join                     ;Let's save a byte of code
0072 DC0E
0073 DC0E
0074 DC0E 38           SchReset sec                            ;Indicate from here
0075 DC0F A9 00 00     Join     lda   #$0000                   ;initialize flags and counters
0076 DC12 8F FF 00 E1           sta   >busyflag
0077 DC16 8F DE 1D E0           sta   >schActive               ; init this too! SEG 14 Nov 88
0078 DC1A A9 FF 00              lda   #$00FF
0079 DC1D 8F EF 1D E0           sta   >offset
0080 DC21 90 04                 bcc   @1
0081 DC23 5C DF FB FE           jml   oEndCall0                ;'c'=1 it's reset so exit gracefully.
0082 DC27              @1        
0083 DC27
0084 DC27              *  Set up $E1 jump vectors
0085 DC27
0086 DC27
0087 DC27 A9 07 DD              lda   #incbusy
0088 DC2A 8F 65 00 E1           sta   >incbusyflg+1
0089 DC2E A9 94 DC              lda   #decbusy
0090 DC31 8F 69 00 E1           sta   >decbusyflg+1
0091 DC35
0092 DC35
0093 DC35                       LONGA OFF
0094 DC35 E2 30                 sep   #$30                     ;8 bit mode to setup vector
0095 DC37 A9 FC                 lda   #^IncBusy                ; bank # of code
0096 DC39 8F 67 00 E1           sta   >incbusyflg+3            ;Warning, this assumes both in same
0097 DC3D 8F 6B 00 E1           sta   >decbusyflg+3            ; bank which is not unreasonable.
0098 DC41                       LONGA ON
0099 DC41 C2 30                 rep   #$30                     ;16 bit mode to continue
0100 DC43
0101 DC43
0102 DC43
0103 DC43              SchAppInit  
0104 DC43              SchApTerm  
0105 DC43 5C DF FB FE           jml   oEndCall0
0106 DC47
0107 DC47
0108 DC47
0109 DC47
0110 DC47              SchVersion  
0111 DC47              result   equ   7
0112 DC47
0113 DC47
0114 DC47 A9 00 03              lda   #$0300                   ; version 2.0 for new rom
0115 DC4A 80 03                 bra   SaveResult               ;Skip SchStatus setup
0116 DC4C
0117 DC4C
0118 DC4C              SchStatus  
0119 DC4C A9 FF FF              lda   #$FFFF
0120 DC4F
0121 DC4F
0122 DC4F              SaveResult  
0123 DC4F 83 07                 sta   result,s
0124 DC51 5C DF FB FE           jml   oEndCall0
0125 DC55
0126 DC55
0127 DC55
0128 DC55
0129 DC55              * Procedure SchFlush;
0130 DC55              *
0131 DC55              * Flush the Scheduler's que. Offset is set to $FF if the que is empty
0132 DC55              schflush  
0133 DC55 A9 FF 00              lda   #$00FF
0134 DC58 8F EF 1D E0           sta   >offset
0135 DC5C 5C DF FB FE           jml   oEndCall0
0136 DC60
0137 DC60
0138 DC60
0139 DC60
0140 DC60              * Function SchAddTask (TaskAddr : LONGINT) :boolean;
0141 DC60              *
0142 DC60              * add a task to Scheduler. If the result is FALSE then there
0143 DC60              * wasn't room to add the task. Result is TRUE otherwise. 
0144 DC60              *
0145 DC60              * Note that there is a limit of 4 tasks that can be present in the
0146 DC60              * Scheduler chain at a given time. If this is a problem, we can 
0147 DC60              * reserve more ram.
0148 DC60              *
0149 DC60
0150 DC60
0151 DC60              schaddtask  
0152 DC60              taskaddr equ   8
0153 DC60              result1  equ   12
0154 DC60
0155 DC60
0156 DC60                       LONGI OFF
0157 DC60                       LONGA OFF
0158 DC60 E2 30                 sep   #$30
0159 DC62 8B                    phb                            ; set up the data bank
0160 DC63 A9 E0                 lda   #$E0
0161 DC65 48                    pha   
0162 DC66 AB                    plb   
0163 DC67
0164 DC67
0165 DC67 AD EF 1D              lda   |offset                  ; number of tasks - 1
0166 DC6A 1A                    inc   a
0167 DC6B C9 04                 cmp   #$04                     ; only 4 task can be in que
0168 DC6D B0 19                 bge   @TheError
0169 DC6F 8D EF 1D              sta   |offset
0170 DC72 0A                    asl   a
0171 DC73 0A                    asl   a
0172 DC74
0173 DC74
0174 DC74 AA                    tax   
0175 DC75
0176 DC75
0177 DC75                       LONGI ON
0178 DC75                       LONGA ON
0179 DC75 C2 30                 rep   #$30
0180 DC77 A3 08                 lda   taskaddr,s               ; copy the task from the stack
0181 DC79 9D DF 1D              sta   |taskque,x               ;   into the que.
0182 DC7C E8                    inx   
0183 DC7D E8                    inx   
0184 DC7E A3 0A                 lda   taskaddr+2,s
0185 DC80 9D DF 1D              sta   |taskque,x
0186 DC83
0187 DC83
0188 DC83 A9 FF 00              lda   #$00FF                   ; return true if the task
0189 DC86 80 05                 bra   @TheError1               ;   was added.
0190 DC88
0191 DC88
0192 DC88              @TheError                               ; return false otherwise.
0193 DC88                       LONGI ON
0194 DC88                       LONGA ON
0195 DC88 C2 30                 rep   #$30
0196 DC8A A9 00 00              lda   #$0000
0197 DC8D              @TheError1  
0198 DC8D 83 0C                 sta   result1,s
0199 DC8F AB                    plb   
0200 DC90 5C 0D FC FE           jml   oEndCall4
0201 DC94
0202 DC94
0203 DC94
0204 DC94
0205 DC94              *****************************************************************
0206 DC94              *
0207 DC94              *   These routines are inserted into the E1 vectors.
0208 DC94              *     they handle decrementing, incrementing and reading the
0209 DC94              *     flag. All registers are preserved.
0210 DC94              *
0211 DC94              *   Note that the routine decbusy will all activate all pending tasks
0212 DC94              *   in the scheduler que. The tasks will get control of the
0213 DC94              *   machine in native mode with interrupts disabled. They may
0214 DC94              *   turn interrupts on. The tasks should return to the scheduler
0215 DC94              *   with an RTL. The dbr is set to $E0 when the task is activated.
0216 DC94              *
0217 DC94
0218 DC94
0219 DC94              ;---------------------------------------------------------------
0220 DC94              ; $E0 variable space for scheduler.
0221 DC94              ;---------------------------------------------------------------
0222 DC94              SchActive equ   $E01DDE                 ; new flag for whether we are active
0223 DC94              taskque  equ   $E01DDF                  ; 16 byte que -- 4 items
0224 DC94              firstTask equ   $E01DDF
0225 DC94              secondTask equ   $E01DE3                ; second item in que
0226 DC94              offset   equ   $E01DEF
0227 DC94              ;---------------------------------------------------------------
0228 DC94
0229 DC94
0230 DC94
0231 DC94
0232 DC94              ;---------------------------------------------------------------
0233 DC94              ; this routine decrements the busy flag and checks to see if it
0234 DC94              ; needs to run any tasks in the scheduler que. If it does, it will
0235 DC94              ; preserve all the registers, call all the que routines, and finally
0236 DC94              ; clear out the que. Each task will get control of the machine in native
0237 DC94              ; mode with interrupts disabled. Each one may turn interrupts on. The
0238 DC94              ; tasks should return to the scheduler with an RTL. The data bank is set
0239 DC94              ; to $E0 when the task is activated.
0240 DC94              ;---------------------------------------------------------------
0241 DC94 08           DecBusy  php                            ;save interrupt status
0242 DC95 78                    sei   
0243 DC96 48                    pha                            ;preserve the A-Reg
0244 DC97
0245 DC97 AF FF 00 E1           lda   >BusyFlag                ;decrement the busy flag
0246 DC9B 3A                    dec   a
0247 DC9C 8F FF 00 E1           sta   >BusyFlag
0248 DCA0 F0 0C                 beq   alreadyZero              ;if at zero, check to see if we have tasks
0249 DCA2 30 03                 bmi   setZero                  ;prevent the flag from going below zero
0250 DCA4
0251 DCA4 68           exitBusy pla   
0252 DCA5 28                    plp   
0253 DCA6 6B                    rtl   
0254 DCA7
0255 DCA7 A9 00 00     setZero  lda   #$0000
0256 DCAA 8F FF 00 E1           sta   >BusyFlag
0257 DCAE
0258 DCAE AF DE 1D E0  alreadyZero lda    >schActive           ;do we have tasks ?
0259 DCB2 29 FF 00              and   #$00FF                   ;active flag is only one byte.
0260 DCB5 D0 ED                 bne   exitBusy                 ;..nope, so exit.
0261 DCB7
0262 DCB7 AF EE 1D E0           lda   >offset-1                ;the high byte is offset, so this will
0263 DCBB 10 03                 bpl   TasksToRun               ; if not neg, there are tasks to run.
0264 DCBD
0265 DCBD 68                    pla                            ; restore and get out
0266 DCBE 28                    plp   
0267 DCBF 6B                    rtl   
0268 DCC0
0269 DCC0
0270 DCC0              TasksToRun  
0271 DCC0
0272 DCC0
0273 DCC0
0274 DCC0              ;---------------------------------------------------------------
0275 DCC0 DA                    phx                            ;save the registers
0276 DCC1 5A                    phy   
0277 DCC2 E2 20                 sep   #%00100000               ;short mode for speed ???
0278 DCC4                       LONGA off
0279 DCC4 8B                    phb                            ;save the user's data bank
0280 DCC5 A9 E0                 lda   #$E0                     ;set data bank to $E0
0281 DCC7 48                    pha   
0282 DCC8 AB                    plb   
0283 DCC9 A9 01                 lda   #$01                     ; set active flag to prevent recursive
0284 DCCB 8D DE 1D              sta   |schActive               ; calls to tasks. JW 9-23-86
0285 DCCE
0286 DCCE 4B           doNextTask phk                          ;push our return address
0287 DCCF 62 0B 00              per   @return-1
0288 DCD2
0289 DCD2 AD E1 1D              lda   |firstTask+2             ;fancy way of jumping to the task to
0290 DCD5 48                    pha                            ;..execute
0291 DCD6 C2 20                 rep   #%00100000               ;the task is executed in long mode
0292 DCD8                       LONGA on
0293 DCD8 AD DF 1D              lda   |firstTask
0294 DCDB 3A                    dec   a
0295 DCDC 48                    pha   
0296 DCDD 6B                    rtl   
0297 DCDE
0298 DCDE C2 30        @return  rep   #$30                     ;make sure we are in long mode
0299 DCE0                       LONGA on
0300 DCE0                       LONGI on
0301 DCE0 F4 E0 E0              pea   $E0E0                    ;set the data bank back to $E0
0302 DCE3 AB                    plb   
0303 DCE4 AB                    plb   
0304 DCE5 78                    sei                            ;make sure interrupts are off
0305 DCE6 A2 00 00              ldx   #0                       ;move all the tasks up one in the que
0306 DCE9 BD E3 1D     @loop    lda   |secondTask,x
0307 DCEC 9D DF 1D              sta   |firstTask,x
0308 DCEF E8                    inx   
0309 DCF0 E8                    inx   
0310 DCF1 E0 0E 00              cpx   #$000C+2
0311 DCF4 90 F3                 blt   @loop
0312 DCF6
0313 DCF6 E2 20                 sep   #%00100000               ;short mode for speed ???
0314 DCF8                       LONGA off
0315 DCF8 CE EF 1D              dec   |offset                  ;decrement our count
0316 DCFB 10 D1                 bpl   doNextTask
0317 DCFD
0318 DCFD 9C DE 1D              stz   |schActive
0319 DD00 C2 20                 rep   #%00100000
0320 DD02                       LONGA on
0321 DD02 AB                    plb   
0322 DD03 7A                    ply   
0323 DD04 FA                    plx   
0324 DD05 80 9D                 bra   exitBusy
0325 DD07              ;---------------------------------------------------------------
0326 DD07
0327 DD07
0328 DD07
0329 DD07
0330 DD07              ;---------------------------------------------------------------
0331 DD07              ; This routine increments the busy flag and saves the A-Reg
0332 DD07              ;---------------------------------------------------------------
0333 DD07 08           IncBusy  php   
0334 DD08 78                    sei   
0335 DD09 48                    pha   
0336 DD0A AF FF 00 E1           lda   >BusyFlag
0337 DD0E 1A                    inc   a
0338 DD0F 8F FF 00 E1           sta   >BusyFlag
0339 DD13 68                    pla   
0340 DD14 28                    plp   
0341 DD15 6B                    rtl   
0342 DD16
0343 DD16              ;---------------------------------------------------------------
0344 DD16
0345 DD16
0346 DD16
0347 DD16
0348 DD16              ;---------------------------------------------------------------
0349 DD16              ; NOTE: this routine does not preserve the registers since it
0350 DD16              ; returns something in A-Reg... Golly Gee !!! (Does anybody call
0351 DD16              ; this routine ??!?)
0352 DD16              ;---------------------------------------------------------------
0353 DD16 AF FF 00 E1  ReadBusy lda   >BusyFlag
0354 DD1A 6B                    rtl   
0355 DD1B              ;---------------------------------------------------------------
0356 DD1B
0357 DD1B
0358 DD1B                       ENDP 
0359 DD1B
0360 DD1B              ****************************************************************
0361 DD1B
0362 DD1B                       END   
